#!/bin/bash

echo ""
sudo chmod ugo+x genji-*

echo "  Copying genji-devchange to /usr/local/bin"
sudo cp genji-devchange /usr/local/bin

echo "  Copying the rule file to /etc/udev/rules.d"
sudo cp 99-genji.rules /etc/udev/rules.d

echo "  Copy the dynamic libary to /usr/local/bin"
sudo cp libgenji.so /usr/local/lib
sudo ldconfig /usr/local/lib

echo "  Reloading the udev rules"
sudo udevadm control --reload-rules
sudo udevadm trigger

echo ""
echo "Now run ./genji-devchange-notify, connect/remove a genji dongle and see if the changes are notified"
echo "" 
echo "If not notified, reboot the computer and run genji-devchange-notify again"
echo ""
