
package main

import (
	"fmt"
	"time"
	"example.com/genji"
)


func readSerNr(UserCode int32, dNr int16) bool {

	fmt.Println("\n --- Genji No.", dNr, " ---")

	length := 16
    buf := make([]byte, length)

	var ret int16 = genji.Dongle_ReadGUSN(UserCode, buf, dNr )
	if ret != 1{
		fmt.Println( "ReadGUSN error:", ret)
		return false
	}

	fmt.Print("  GUSN =")
	for i :=0 ; i < 16 ; i++{
		fmt.Printf("%c", buf[i])
	}
	fmt.Println("")

	var serNr int32 = genji.Dongle_ReadSerNr(UserCode, dNr)
	fmt.Printf("  SerNr=%d\n", serNr)
	if serNr <= 0 {
		return false
	}

	return true
}


func detectGenji(UserCode int32 ) int16 {

	fmt.Println("\n***** Detecting Genji *****")

	var ret int16 = genji.Init_MatrixAPI()
	if ret < 0	{
		fmt.Println("Init Error;", ret)
		return -1
	}

	var count int16 = genji.Dongle_Count()
	fmt.Println("Genji Count=", count)

	if count < 1 {
		fmt.Println("No dongle found")
		return 0
	}

	time.Sleep(1 * time.Second)

	for i:=(int16)(1) ; i <= count; i++{
		if readSerNr(UserCode, (int16)(i)) == false{
			return -1
		}
		time.Sleep(1 * time.Second)
	}

	return count
}
