package jp.co.ribig.genji;


import java.io.IOException;

public class ELGenji
{

	public static class tm{
	    public int tm_sec;   // seconds after the minute - [0, 60] including leap second
	    public int tm_min;   // minutes after the hour - [0, 59]
	    public int tm_hour;  // hours since midnight - [0, 23]
	    public int tm_mday;  // day of the month - [1, 31]
	    public int tm_mon;   // months since January - [0, 11]
	    public int tm_year;  // years since 1900
	    public int tm_wday;  // days since Sunday - [0, 6]
	    public int tm_yday;  // days since January 1 - [0, 365]
	    public int tm_isdst; // daylight savings time flag
	}

    private static String libName;

    static {
        libName = System.mapLibraryName("genji");
        try {
            System.loadLibrary("genji");
        }
        catch(UnsatisfiedLinkError e) {
            System.err.println("Unable to load library [" + libName + "]");
            throw e;
        }
    }

    public static native void RegisterGenjiCallbackPort(int port);

    public static native short Init_MatrixAPI();

    public static native short Release_MatrixAPI();

    public static native int GetVersionAPI();

    public static native int GetVersionDRV();

    public static native int GetVersionDRV_USB();

    public static native short Dongle_Find();

    public static native short Dongle_FindEx(short[] DNG_Info);

    public static native short Dongle_Count(short PortNr);

    public static native int Dongle_Version(short DongleNr, short PortNr);

    public static native int Dongle_Model(short DongleNr, short PortNr);

    public static native short Dongle_MemSize(short DongleNr, short PortNr);

    public static native short Dongle_ReadData(int UserCode, int[] pDataIn, short Count,
                                                             short DongleNr, short PortNr);

    public static native short Dongle_ReadDataEx(int UserCode, int[] pDataIn, short Fpos, short Count,
                                                               short DongleNr, short PortNr);

    public static native int Dongle_ReadSerNr(int UserCode, short DongleNr, short PortNr);

    public static native short Dongle_WriteData(int UserCode, int[] pDataOut, short Count,
                                                              short DongleNr, short PortNr);

    public static native short Dongle_WriteDataEx(int UserCode, int[] DataOut, short Fpos, short Count,
                                                                short DongleNr, short PortNr);

    public static native short Dongle_WriteKey(int UserCode, int[] pKeyData, short DongleNr, short PortNr);

    public static native short Dongle_GetKeyFlag(int UserCode, short DongleNr, short PortNr);

    public static native short Dongle_EncryptData(int UserCode, int[] pDataBlock,
                                                                short DongleNr, short PortNr);

    public static native short Dongle_DecryptData(int UserCode, int[] pDataBlock,
                                                                short DongleNr, short PortNr);

    
    public static native short SetConfig_MatrixNet(short nAccess, String nFile);

    public static native int GetConfig_MatrixNet(short Category);

    public static native short LogIn_MatrixNet(int UserCode, short AppSlot, short DongleNr);

    public static native short LogOut_MatrixNet(int UserCode, short AppSlot, short DongleNr);



	public static native short Dongle_SetLED( short mode, short dNr, short PortNr );
	public static native short Dongle_GetRand( int  UserCode, short siz, byte[] pRand, short dNr, short PortNr );
	public static native short Dongle_GetTime( int  UserCode, tm pCurTime, short dNr, short PortNr);
	public static native short Dongle_ReadGUSN( int UserCode, byte[] gSN, short dNr,short PortNr);


	public static native short Dongle_CreateRSAKeyPair( int UserCode, short idx, short dNr, short PortNr );

	public static native short  Dongle_WriteRSAKey( int UserCode, short idx, int bPrivKey, short keySize, byte[] pKeyBuf, short dNr, short PortNr);

	public static native short Dongle_LockRSAKeyPair( int UserCode, short idx, int bLock, int lockKey, short dNr, short PortNr );

	public static native short Dongle_GetRSAPubKey( int UserCode, short idx, byte[] pubKey, short[] pubKeyLen, short dNr, short PortNr );

	public static native short  EncryptByCOSRsaPubKey( byte[] pubKey, short pubKey_len, byte[] plainText, short plainTextLen,		byte[]r, short[] cipherLen);

	public static native short  Dongle_EncryptDataRSA( int UserCode, short idx, 
				 byte[] plainText, short plainTextLen, byte[] cipher, short[] cipherLen,
				 short dNr, short PortNr );

	public static native short Dongle_DecryptDataRSA( int UserCode, short idx, 
				 byte[] cipher, short cipherLen, byte[] plainText, short[] plainTextLen,
				 short dNr, short PortNr );

	public static native short  Dongle_SignDataRSA( int UserCode, short idx,
		byte[] msg, short msgLen, byte[] sigData, short[] sigLen,
		short dNr, short PortNr);

	public static native short  Dongle_VerifySigRSA(int UserCode, short idx,
		byte[] msg, short msgLen, byte[] sigData, short sigLen,
		short dNr, short PortNr);

	public static native short Dongle_DecryptDataTDES( int UserCode, byte[] iv, byte[] cipher, short cipherLen, 
			byte[] plain, short[] plainLen, short dNr, short PortNr );

	public static native short Dongle_EncryptDataTDES( int UserCode, byte[] iv, byte[] plainText, short plainLen, 
			byte[] cipher, short[]cipherLen,short dNr, short PortNr );

	public static native short  Dongle_WriteKeyTDES( int UserCode, byte[] key, short dNr,short PortNr );

	public static native short  Dongle_WriteKeyHMACSHA1( int UserCode, byte[] key, short dNr, short PortNr );

	public static native short  Dongle_HMACSHA1(int  UserCode, byte[] plainText,short plainLen, 
				byte[] hash, short[]hashLen, short dNr, short PortNr );

	public static native short  Dongle_MemSize2( short dNr, short PortNr);

	public static native short  Dongle_WriteData2( int UserCode, byte[] data, short pos, short len, short dNr, short PortNr);
	public static native short  Dongle_ReadData2( int  UserCode, byte[] data, short pos,short len, short dNr,short PortNr);

	public static native short  Dongle_LockData2( int UserCode, int bLock, int lockKey, short dNr, short PortNr);

	public static native short  Dongle_LockData( int UserCode, int bLock, int lockKey, short dNr, short PortNr);

	public static native short  Dongle_SetTimer( int UserCode, short mode,  short dNr, short PortNr);
	public static native short  Dongle_StartTimer(int UserCode, short dNr, short PortNr);
	public static native short  Dongle_GetTimer(int UserCode, int[] dwCount, short dNr, short PortNr);
	public static native short  Dongle_StopTimer(int UserCode, short dNr, short PortNr);


}

