
import time

def detectGenji( gnjAPI ):
    count = gnjAPI.count()
    if count < 1:
        return 0

    print("\nGenji Count", gnjAPI.count())

    for dngNr in range(1,count+1):
        print ("\n  *** Genji No." + str(dngNr) + " *** ")
        print("     Mem Size:", gnjAPI.mem_size(dngNr))
        
        sernr = gnjAPI.ser_no(1234,dngNr);
        print("     Serial# :", sernr)

        if sernr < 1:
            print("     Serial # error:", sernr)
            return 0

        gusn = bytes(16)
        ret = gnjAPI.read_gusn(1234, gusn, dngNr)

        if ret == 1:
            print( "     GUSN   :" + gusn.decode() );
        else:
            print("     GUSN Error", ret)

    time.sleep(2)

    return count

def get_rtc_time( gnjAPI, dng_nr ):

    ret,cur_time = gnjAPI.get_time( 1234, dng_nr)

    if ret == 1:
        cur_time.tm_year += 1900
        cur_time.tm_mon += 1

    return ret, cur_time

def rtc_time( gnjAPI, dng_nr):
    
    print( "     ***** RTC Time *****")

    ret, tm = get_rtc_time( gnjAPI, dng_nr )
    if ret == 1:
        print( "     " + str(tm.tm_year) + "年" + str(tm.tm_mon) + "月" + str(tm.tm_mday) + "日 " 
                + str(tm.tm_hour) + "時" + str(tm.tm_min) + "分" + str(tm.tm_sec) + "秒")
    elif ret == -10:
        print( "     Genji without RTC" )
        ret=1
    else:
        return False
    
    time.sleep(2)
    return True

def led_test( gnjAPI, dng_nr):

    print("    LED Off")
    gnjAPI.set_led( 0, dng_nr)
    time.sleep(2)
    print("    LED Blink")
    gnjAPI.set_led( 3, dng_nr)
    time.sleep(2)
    print("    LED Off")
    gnjAPI.set_led( 0, dng_nr)
    time.sleep(2)
    print("    LED On")
    gnjAPI.set_led( -1, dng_nr)
    time.sleep(2)
