﻿#include <iostream>
#include "genji.h"

#if defined(_WIN64)
#pragma comment(lib, ".\\lib\\x64\\genji-mt-vs2022.lib")
#else
#pragma comment(lib, ".\\lib\\x86\\genji-mt-vs2022.lib")
#endif

bool FindGenji();
bool LEDTest();
bool MemSizeGUSNTest();
bool Data2Test();
bool CreateRSAKey(short keyIdx);
bool RSAEncryptTest(int idx);
bool RSASignTest(int idx);
bool RSAKeyImport(int keyIdx);
bool RandTest();
bool RTCTimeTest();
void cleanup();

void devChange(bool removed)
{
    std::cout << "Genji抜差: " << (removed == true ? "unplug" : "plug") << std::endl;
}

int main()
{
    RegisterGenjiCallback(devChange);

    if (false == FindGenji()) goto main_exit;

    if (false == LEDTest()) goto main_exit;

    if (false == MemSizeGUSNTest()) goto main_exit;

    if (false == Data2Test()) goto main_exit;

    if (false == CreateRSAKey(1)) goto main_exit;
    if (false == RSAEncryptTest(1)) goto main_exit;
    if (false == RSASignTest(1)) goto main_exit;

    if (true == RSAKeyImport(2))
    {
        if (false == RSAEncryptTest(2)) goto main_exit;
        if (false == RSASignTest(2)) goto main_exit;
    }

    if (false == RandTest()) goto main_exit;

    RTCTimeTest();

main_exit:
    RegisterGenjiCallback(NULL);

    cleanup();

    return 0;
}


