#include <windows.h>
#include <iostream>
#include <string>
#include <memory>
#include <sstream>
#include <cstdlib>
#include <iomanip>

#include "genji.h"
#include "timer.h"
#include "util.h"

int32_t UserCode = 1234;
int16_t PortNr = 85;
int16_t DngNr = 1;

bool FindGenji()
{
    Init_MatrixAPI();

    short nCount = Dongle_Count(85);
    if (nCount < 1)
    {
        std::cout << "Genji܂:" << nCount << std::endl;
        Release_MatrixAPI();
        return false;
    }
    else
        std::cout << "Genji܂:" << nCount << std::endl;

    return true;
}

bool LEDTest()
{
    std::cout << "\n***** LED *****" << std::endl;

    std::cout << "LED" << std::endl;
    if (1 != Dongle_SetLED(0, DngNr, PortNr))
        return false;
    pause();

    std::cout << "LED_" << std::endl;
    if (1 != Dongle_SetLED(3, DngNr, PortNr))
        return false;
    pause();

    std::cout << "LED_" << std::endl;
    if (1 != Dongle_SetLED(-1, DngNr, PortNr))
        return false;
    pause();

    std::cout << "LED" << std::endl;
    if (1 != Dongle_SetLED(0, DngNr, PortNr))
        return false;
    pause();

    std::cout << "LED_" << std::endl;
    if (1 != Dongle_SetLED(-1, DngNr, PortNr))
        return false;

    std::cout << "**********" << std::endl;
    pause();

    return true;
}

bool MemSizeGUSNTest()
{
    std::cout << "\n***** Genji SN *****" << std::endl;

    unsigned char szGUSN[24];
    SecureZeroMemory(szGUSN, 24);

    short ret;
    if (1 == (ret = Dongle_ReadGUSN(UserCode, szGUSN, DngNr, PortNr)))
        std::cout << "GUSN:" << szGUSN << std::endl;
    else
    {
        std::cout << "GUSN擾G[: " << ret << std::endl;
        return false;
    }

    std::cout << "**********" << std::endl;

    pause();
    return true;
}

bool Data2Test()
{
    std::cout << "\n***** f[^̈#2 *****" << std::endl;

    short memSize2 = Dongle_MemSize2(DngNr, PortNr);
    if (memSize2 > 0)
        std::cout << "TCY : " << memSize2 << " oCg" << std::endl << std::endl;
    else
        return false;

    pause();

    std::cout << "ރf[^͌ARETURN" << std::endl;
    MessageBeep(0);

    std::string s;
    if (std::getline(std::cin, s)) {

        int32_t dataLen = (int32_t)s.length();

        if (dataLen + 4 > memSize2)
        {
            std::cout << "f[^܂" << std::endl;
            return false;
        }
        else if (dataLen == 0)
        {
            std::cout << "f[^XLbv" << std::endl;
            return true;
        }

        std::unique_ptr<unsigned char[]> data = std::make_unique<unsigned char[]>(dataLen + sizeof(int32_t));

        memcpy(&data[0], &dataLen, sizeof(int32_t));
        memcpy(&data[sizeof(int32_t)], s.c_str(), dataLen);

        short ret;
        if ((ret = Dongle_WriteData2(UserCode, data.get(), 0, (int16_t)(dataLen + sizeof(int32_t)), DngNr, PortNr)) < 0)
        {
            std::cout << "ݎs: " << ret << std::endl;
            return false;
        }

        std::cout << "\n݂܂(f[^ " << sizeof(int32_t) << "oCg +  f[^ " << dataLen << ") =" << ret << std::endl << std::endl;
        std::cout << "ɓǂݍ݂܂" << std::endl;
        pause();

        //Ǎ
        dataLen = 0;
        if ((ret = Dongle_ReadData2(UserCode, (unsigned char*)&dataLen, 0, sizeof(int32_t), DngNr, PortNr)) < 0)
        {
            std::cout << "f[^̓ǂݍݎs: " << ret << std::endl;
            return false;
        }

        std::cout << "f[^Ǎ: " << dataLen << std::endl;

        std::unique_ptr<unsigned char[]> data2 = std::make_unique<unsigned char[]>(dataLen + 1);
        data2[dataLen] = 0;

        if ((ret = Dongle_ReadData2(UserCode, data2.get(), sizeof(int32_t), dataLen, DngNr, PortNr)) < 0)
        {
            std::cout << "f[^ǂݍݎs: " << ret << std::endl;
            return false;
        }

        std::cout << "f[^ǂݍ݂܂: " << ret << std::endl;
        std::cout << data2 << std::endl;

    }
    else
        return false;

    std::cout << "**********" << std::endl << std::endl;
    pause();

    return true;
}


bool CreateRSAKey(short keyIdx)
{
    short    ret;
    double   interval;

    std::unique_ptr<CTimer> timer = std::make_unique<CTimer>();

    std::cout << "\n***** RSAL[(#" << keyIdx << ")*****" << std::endl;

    timer->start();

    ret = Dongle_CreateRSAKeyPair(UserCode, keyIdx, DngNr, PortNr);

    interval = timer->interval();
    timer->stop();

    if (ret != 1)
    {
        std::cout << "L[yAG[: " << ret << std::endl;
        return false;
    }

    std::cout << "\nooooo L[yA(#" << keyIdx << ")𐶐܂ ooooo" << std::endl;
    std::cout << "L[yA(#" << keyIdx << "):" << interval << " millsec" << std::endl;
    pause();

    return true;
}


bool RSAEncryptTest(int keyIdx)
{
    short    ret;
    double   interval;

    std::cout << "\n***** Í/(#" << keyIdx << ") *****" << std::endl;

    std::unique_ptr<CTimer> timer = std::make_unique<CTimer>();

retry:
    std::cout << "\nÍf[^(ő117oCg)͌ARETURN" << std::endl;
    MessageBeep(0);

    std::string s;
    if (std::getline(std::cin, s)) {

        trim(s);
        int32_t dataLen = (int32_t)s.length();

        if (dataLen == 0)
        {
            std::cout << "ÍeXgXLbv" << std::endl;
            return true;
        }
        

        if (dataLen > 117)
        {
            std::cout << "f[^܂" << std::endl;
            return false;
        }

        unsigned char cipher[250];
        short cipherLen = 250;

        timer->start();

        ret = Dongle_EncryptDataRSA(UserCode, keyIdx, (const unsigned char*)s.c_str(), (short)s.length(), cipher, &cipherLen, DngNr, PortNr);

        interval = timer->interval();
        timer->stop();

        if (ret != 1)
        {
            std::cout << "\nÍG[: " << ret << std::endl;
            return false;
        }

        std::cout << "\nooooo Í܂ ooooo" << std::endl;
        std::cout << "Íɂ:" << interval << "msec" << std::endl;

        //Íf[^iHEXj̕\
        printHex(cipher, cipherLen);
        pause();

        short plainTextLen = 128;
        unsigned char plainText[128];

        timer->start();

        ret = Dongle_DecryptDataRSA(UserCode, keyIdx, cipher, cipherLen, plainText, &plainTextLen, DngNr, PortNr);

        interval = timer->interval();
        timer->stop();

        if (ret == 1)
        {
            std::cout << "\nooooo ܂ ooooo" << std::endl;
            std::cout << "ɂt=" << interval << "msec" << std::endl;

            plainText[plainTextLen] = 0;
            std::cout << plainText << std::endl;
            pause();

        }
        else
            std::cout << "G[" << std::endl;
    }
    else
        return false;


    return true;
}

bool RSASignTest(int keyIdx)
{
    short ret = 0;
    double interval;

    std::unique_ptr<CTimer> timer = std::make_unique<CTimer>();

    std::cout << "\n***** / *****" << std::endl;

retry:
    std::cout << "\nf[^͌ARETURN" << std::endl;
    MessageBeep(0);

    std::string s;
    if (std::getline(std::cin, s)) {

        trim(s);
        int32_t dataLen = (int32_t)s.length();

        if (dataLen == 0)
        {
            std::cout << "eXgXLbv" << std::endl;
            return true;
        }


        unsigned char sig[250];
        short sigLen = 250;

        timer->start();

        ret = Dongle_SignDataRSA(UserCode, keyIdx, (unsigned char*)s.c_str(), dataLen, sig, &sigLen, DngNr, PortNr);

        interval = timer->interval();
        timer->stop();

        if (ret != 1)
        {
            std::cout << "\nG[: " << ret << std::endl;
            return false;
        }

        std::cout << "\nooooo ܂ ooooo" << std::endl;
        std::cout << "ɂt=" << interval << "msec" << std::endl;

        //HEX\
        printHex(sig, sigLen);
        pause();


        //
        timer->start();

        ret = Dongle_VerifySigRSA(UserCode, keyIdx, (unsigned char*)s.c_str(), dataLen, sig, sigLen, DngNr, PortNr);

        interval = timer->interval();
        timer->stop();

        if (ret != 1)
        {
            std::cout << "\n؃G[: " << ret << std::endl;
            return false;
        }

        std::cout << "\n Ok" << std::endl;
        std::cout << "؂ɂt=" << interval << "msec" << std::endl;
        pause();

    }
    else
        return false;

    return true;

}

bool writeRSAKey(bool bPrivKey, int keyIdx, const char* filename)
{
    FILE* fp;
    errno_t err = fopen_s(&fp, filename, "rb");

    if (!err)
    {
        fseek(fp, 0, SEEK_END);
        long fsize = ftell(fp);
        fseek(fp, 0, SEEK_SET);

        std::unique_ptr<unsigned char[]> data = std::make_unique<unsigned char[]>(fsize);

        size_t bytesRead = fread(data.get(), 1, fsize, fp);
        if (bytesRead != static_cast<size_t>(fsize)) {
            std::cerr << "Read error: expected " << fsize
                << " bytes, got " << bytesRead << " bytes\n";
            fclose(fp);
            return false;
        }

        fclose(fp);

        short ret = Dongle_WriteRSAKey(UserCode, keyIdx, bPrivKey == true ? TRUE : FALSE, (uint16_t)fsize, data.get(), 1, 85);
        if (ret == 1)
        {
            std::cout << filename << " imported to genji" << std::endl;
            return true;
        }
        else
            std::cout << filename << " failed to be imported" << std::endl;

    }
    else
        std::cout << "File " << filename << " open error" << std::endl;

    return false;
}

bool RSAKeyImport(int keyIdx)
{
    std::cout << "\n*****\nOL[yÃC|[g*****" << std::endl;

    if (true == writeRSAKey(true, keyIdx, "genji.privkey"))
    {
        if (true == writeRSAKey(false, keyIdx, "genji.pubkey"))
        {
            pause();
            return true;
        }
    }

    std::cout << "\n*****\nOL[yAC|[gXLbv*****" << std::endl;
    pause();
    return false;

}

bool RandTest()
{
    short ret = 0;
    double interval;

    std::unique_ptr<CTimer> timer = std::make_unique<CTimer>();

    std::cout << "\n*****  *****" << std::endl;

    unsigned char byteRand[32];
    short randLen = 32;

    for (int i = 0; i < 10; i++)
    {
        std::cout << "\n>> " << i + 1 << " " << std::endl;
        timer->start();

        ret = Dongle_GetRand(UserCode, randLen, byteRand, DngNr, PortNr);

        interval = timer->interval();
        timer->stop();

        if (ret == 1)
        {

            std::cout << "oooo  ooooo" << std::endl;
            std::cout << "ɂt=" << interval << "msec" << std::endl;
            printHex(byteRand, randLen);
        }
        else
        {
            std::cout << "G[: " << ret << std::endl;
            return false;
        }

        pause(1000);
    }

    return true;
}

bool RTCTimeTest()
{
    std::cout << "\n***** RTC *****" << std::endl;

    struct tm rtcTime;
    short ret = Dongle_GetTime(UserCode, &rtcTime, DngNr, PortNr);
    if (ret == 1)
    {
        std::cout << rtcTime.tm_year+1900 << "N" << rtcTime.tm_mon+1 << "" << rtcTime.tm_mday << "@" << rtcTime.tm_hour << "" << rtcTime.tm_min << "" << rtcTime.tm_sec << "b";
        return true;
    }
    else
    {
        if (ret == -10)
            std::cout << " <<RTC>>" << std::endl;
        else
            std::cout << "GetTimeG[:" << ret << std::endl;
    }

    return false;
}


void cleanup()
{
    std::cout << "\n\n<<<<< fI >>>>>" << std::endl;
    std::cout << "RETURN ŃvOI" << std::endl;
    (void)getchar();

    Release_MatrixAPI();
}