﻿using GenjiDotNet;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NetCoreSample
{
    public partial class RSAForm : Form
    {
        GenjiDotNet.API api;

        public RSAForm(GenjiDotNet.API api_)
        {
            InitializeComponent();
            api = api_;
        }

        private void Encrypt_Click(object sender, EventArgs e)
        {
            try
            {
                if (PlainText.Text.Trim().Length == 0)
                {
                    MessageBox.Show("テキストが空です");
                    return;
                }

                byte[] bytePlainText = System.Text.Encoding.UTF8.GetBytes(PlainText.Text);
                if (bytePlainText.Length > 117)
                {
                    MessageBox.Show("データが長すぎます");
                    return;
                }

                api.Init();
                api.Count();

                byte[] cipher = new byte[256];
                short cipherLen = (short)cipher.Length;

                api.EncryptDataRSA(1234, 1, bytePlainText, (short)bytePlainText.Length, cipher, ref cipherLen, 1);
                byte[] cipher1 = new byte[cipherLen];
                System.Buffer.BlockCopy(cipher, 0, cipher1, 0, cipherLen);

                string hexString = Convert.ToHexString(cipher1);
                CipherText.Text = hexString;

                labelLength.Text = "長さ(バイナリ)=" + cipher1.Length;

                PlainText.Text = "";
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiが見つかりません");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "復号化");
            }

            api.Release();
        }

        private void Decrypt_Click(object sender, EventArgs e)
        {
            byte[] bytePlainText2 = new byte[128];
            short plainTextLen2 = 128;

            try
            {
                if (CipherText.Text.Trim().Length == 0)
                {
                    MessageBox.Show("暗号化文字列が空です", "復号化");
                    return;
                }

                api.Init();
                api.Count();

                byte[] cipher = Convert.FromHexString(CipherText.Text);
                short cipherLen = (short)cipher.Length;

                api.DecryptDataRSA(1234, 1, cipher, cipherLen, bytePlainText2, ref plainTextLen2, 1);
                labelLength.Text = "";
                CipherText.Text = "";
                PlainText.Text = System.Text.Encoding.UTF8.GetString(bytePlainText2);
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiが見つかりません");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "復号化");
            }

            api.Release();
        }

        private void createKey_Click(object sender, EventArgs e)
        {
            try
            {
                if (MessageBox.Show("キーペアを生成しますか？", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    api.Init();
                    api.Count();

                    api.CreateRSAKeyPair(1234, 1, 1);
                    MessageBox.Show("生成しました");
                }
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiが見つかりません");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();

        }
    }

}
