using GenjiDotNet;

namespace NetCoreSample
{
    public partial class Form1 : Form
    {
        GenjiDotNet.API api = new GenjiDotNet.API();
        uint devChangeMsg = WinAPI.RegisterWindowMessage("ELDongleAPI_Device_Change");

        public Form1()
        {
            InitializeComponent();

            api.Init();
            api.Release();
        }

        ~Form1()
        {
        }

        private void ReadGUSN_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();
                MessageBox.Show(api.ReadGUSN(1234, 1));
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);
            }

            api.Release();
        }

        void SleepTimerFunc(object? arg)
        {
            try
            {
                api.Init();
                api.Count();

                ELTimer timer = new ELTimer(1234, 1);

                timer.Start();

                Thread.Sleep(5000);

                timer.Stop();

                MessageBox.Show("5b(5000~b)X[vĂԂ̃NbNJEg=" + timer.Count() + "\n^C}[v̌oߎ=" + timer.Millsec() + "~b");
                Timer.Enabled = true;

            }
            catch (APIException) { }
            catch (Exception) { }

            api.Release();
        }

        private void Timer_Click(object sender, EventArgs e)
        {
            try
            {
                Timer.Enabled = false;
                ThreadPool.QueueUserWorkItem(SleepTimerFunc);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void Data_Click(object sender, EventArgs e)
        {
            dataForm frm = new dataForm(api);
            frm.ShowDialog();

            return;
        }

        private void RSAEncrypt_Click(object sender, EventArgs e)
        {
            RSAForm rsaForm = new RSAForm(api);
            rsaForm.ShowDialog();

            return;
        }

        private void WriteLock_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();

                api.Count();
                api.LockData2(1234, 1, 987654123, 1);
                MessageBox.Show("bN");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);
            }

            api.Release();
        }

        private void WriteUnlock_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.LockData2(1234, 0, 987654123, 1);
                MessageBox.Show("AbN");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();

        }

        private void LEDON_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.SetLED(-1, 1);
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();
        }

        private void LEFOFF_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.SetLED(0, 1);
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();
        }

        private void LEDBLINK_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.SetLED(3, 1);
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();

        }

        private void MemSize2_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                MessageBox.Show("TCY: " + api.MemSize2(1) + "oCg");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();
        }

        private void Rand_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                byte[] byteRand = new byte[32];
                api.GetRand(1234, 32, byteRand, 1);
                MessageBox.Show(Convert.ToHexString(byteRand));
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("GenjiڑĂ");
                else
                    MessageBox.Show(ex.Message + ":" + ex.errorNo);
            }

            api.Release();

        }


        private void Signature_Click(object sender, EventArgs e)
        {
            SigForm sigForm = new SigForm(api);
            sigForm.ShowDialog();

            return;
        }

        //Genji ̔bZ[WŎ󂯎
        // @devChangeMsg = WinAPI.RegisterWindowMessage("ELDongleAPI_Device_Change") 
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == devChangeMsg)
            {
                try
                {
                    api.Init();

                    int count = api.Count();

                    if ((uint)m.WParam == WinAPI.DBT_DEVICEARRIVAL)
                        MessageBox.Show("ڑ:" + count);
                    else
                        MessageBox.Show(":" + count);
                }
                catch (APIException ex)
                {
                    if (ex.Message == "Count" && ex.errorNo == 0)
                        MessageBox.Show(":0");
                    else
                        MessageBox.Show(ex.Message + "- Error;" + ex.errorNo);
                }
                api.Release();

            }

            base.WndProc(ref m);
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {

        }


        /*
                //Genji ̔ UDP Ŏ󂯎
                //RegisterCallbackPort(port);

                System.Net.Sockets.UdpClient? udp;

                    private static void DevChangeThread(Form1 frm1Obj)
                    {
                        //oCh郍[JIPƃ|[gԍ
                        string localIpString = "127.0.0.1";
                        System.Net.IPAddress localAddress =
                            System.Net.IPAddress.Parse(localIpString);
                        int localPort = 10001;

                        //UdpClient쐬A[JGh|CgɃoCh
                        System.Net.IPEndPoint localEP =
                            new System.Net.IPEndPoint(localAddress, localPort);
                        frm1Obj.udp =
                            new System.Net.Sockets.UdpClient(localEP);

                        frm1Obj.api.RegisterGenjiCallbackPort(10001);

                        while (true)
                        {
                            try
                            {
                                System.Net.IPEndPoint remoteEP = new IPEndPoint(IPAddress.Any, 0);
                                byte[] rcvBytes = frm1Obj.udp.Receive(ref remoteEP);

                                string rcvMsg = System.Text.Encoding.UTF8.GetString(rcvBytes);

                                MessageBox.Show(rcvMsg, "foCX");
                            }
                            catch (Exception ex)
                            {
                                //socket closed & disposed ȊO
                                if (ex.HResult != -2147467259 && ex.HResult != -2146232798)
                                    MessageBox.Show(ex.Message + " " + ex.HResult);

                                break;
                            }
                        }

                    }

                    private void Form1_Load(object sender, EventArgs e)
                    {
                        Thread myThread = new Thread(() => DevChangeThread(this));
                        myThread.Start();
                    }

                    private void Form1_FormClosing(object sender, FormClosingEventArgs e)
                    {

                        //UdpClient
                        if( udp != null)
                            udp.Close();

                    }


         */

    }
}