﻿using System.Runtime.InteropServices;   /* Required namespace for the DllImport method */

namespace GenjiDotNetInterop
{
    public struct DNGINFO
    {
        public short LPT_Nr;
        public short LPT_Adr;
        public short DNG_Cnt;
    };

    public class API
    {
        [DllImport("kernel32.dll", SetLastError = true, CharSet = CharSet.Unicode)]
        public static extern bool SetDllDirectory(string lpPathName);

        [DllImport("genji.dll", EntryPoint = "Init_MatrixAPI", CallingConvention = CallingConvention.StdCall)]
        public static extern short Init_MatrixAPI();

        [DllImport("genji.dll", EntryPoint = "Release_MatrixAPI", CallingConvention = CallingConvention.StdCall)]
        public static extern short Release_MatrixAPI();

        [DllImport("genji.dll", EntryPoint = "GetVersionAPI", CallingConvention = CallingConvention.StdCall)]
        public static extern int GetVersionAPI();

        [DllImport("genji.dll", EntryPoint = "GetVersionDRV", CallingConvention = CallingConvention.StdCall)]
        public static extern int GetVersionDRV();

        [DllImport("genji.dll", EntryPoint = "GetVersionDRV_USB", CallingConvention = CallingConvention.StdCall)]
        public static extern int GetVersionDRV_USB();

        [DllImport("genji.dll", EntryPoint = "GetVersionDRV_USB", CallingConvention = CallingConvention.StdCall)]
        public static extern void SetW95Access(short Mode);

        [DllImport("genji.dll", EntryPoint = "GetPortAdr", CallingConvention = CallingConvention.StdCall)]
        public static extern short GetPortAdr(short Port);

        [DllImport("genji.dll", EntryPoint = "PausePrinterActivity", CallingConvention = CallingConvention.StdCall)]
        public static extern short PausePrinterActivity();

        [DllImport("genji.dll", EntryPoint = "ResumePrinterActivity", CallingConvention = CallingConvention.StdCall)]
        public static extern short ResumePrinterActivity();

        [DllImport("genji.dll", EntryPoint = "Dongle_Find", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_Find();

        [DllImport("genji.dll", EntryPoint = "Dongle_FindEx", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_FindEx(ref DNGINFO DngInfo);

        [DllImport("genji.dll", EntryPoint = "Dongle_Version", CallingConvention = CallingConvention.StdCall)]
        public static extern int Dongle_Version(short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_Model", CallingConvention = CallingConvention.StdCall)]
        public static extern int Dongle_Model(short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_MemSize", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_MemSize(short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_Count", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_Count(short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_ReadData", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_ReadData(int UserCode, int[] Data, short Count, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_ReadDataEx", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_ReadDataEx(int UserCode, int[] Data, short Fpos, short Count, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_ReadSerNr", CallingConvention = CallingConvention.StdCall)]
        public static extern int Dongle_ReadSerNr(int UserCode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_WriteData", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_WriteData(int UserCode, int[] Data, short Count, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_WriteDataEx", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_WriteDataEx(int UserCode, int[] Data, short Fpos, short Count, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_WriteKey", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_WriteKey(int UserCode, uint[] KeyData, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_GetKeyFlag", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_GetKeyFlag(int UserCode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_Exit", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_Exit();

        [DllImport("genji.dll", EntryPoint = "SetConfig_MatrixNet", CallingConvention = CallingConvention.StdCall)]
        public static extern short SetConfig_MatrixNet(short nAccess, string nFile);

        [DllImport("genji.dll", EntryPoint = "GetConfig_MatrixNet", CallingConvention = CallingConvention.StdCall)]
        public static extern int GetConfig_MatrixNet(short Category);

        [DllImport("genji.dll", EntryPoint = "LogIn_MatrixNet", CallingConvention = CallingConvention.StdCall)]
        public static extern short LogIn_MatrixNet(int UserCode, short AppSlot, short DngNr);

        [DllImport("genji.dll", EntryPoint = "LogOut_MatrixNet", CallingConvention = CallingConvention.StdCall)]
        public static extern short LogOut_MatrixNet(int UserCode, short AppSlot, short DngNr);

        [DllImport("genji.dll", EntryPoint = "Dongle_EncryptData", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_EncryptData(int UserCode, int[] DataBlock, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_DecryptData", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_DecryptData(int UserCode, int[] DataBlock, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_MemSize2", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_MemSize2(short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_SetLED", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_SetLED(short mode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_LockData", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_LockData(int UserCode, int bLock, uint LockKey, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_LockData2", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_LockData2(int UserCode, int bLock, uint LockKey, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_ReadGUSN", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_ReadGUSN(int UserCode, byte[] gSN, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_WriteData2", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_WriteData2(int UserCode, byte[] data, short pos, short len, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_ReadData2", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_ReadData2(int UserCode, byte[] data, short pos, short len, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_EncryptDataRSA", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_EncryptDataRSA(int UserCode, short keyIdx, byte[] plain, short plainLen, byte[] cipher, ref short cipherLen,  short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_DecryptDataRSA", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_DecryptDataRSA(int UserCode, short keyIdx, byte[] cipher, short cipherLen, byte[] plain, ref short plainLen, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_CreateRSAKeyPair", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_CreateRSAKeyPair(int UserCode, short keyIdx, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_SignDataRSA", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_SignDataRSA(int UserCode, short keyIdx, byte[] msg, short msgLen, byte[] sig, ref short sigLen, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_VerifySigRSA", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_VerifySigRSA(int UserCode, short keyIdx, byte[] msg, short msgLen, byte[] sig, short sigLen, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_SetTimer", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_SetTimer(int UserCode, short mode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_StartTimer", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_StartTimer(int UserCode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_StopTimer", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_StopTimer(int UserCode, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_GetTimer", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_GetTimer(int UserCode, ref uint dwCount, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_GetRand", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_GetRand(int UserCode, short siz, byte[] rand, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_WriteKeyHMACSHA1", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_WriteKeyHMACSHA1(int UserCode, byte[] key, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "Dongle_HMACSHA1", CallingConvention = CallingConvention.StdCall)]
        public static extern short Dongle_HMACSHA1(int UserCode, byte[] plain, short plainLen, byte[] hash, ref short hashLen, short DngNr, short Port);

        [DllImport("genji.dll", EntryPoint = "RegisterGenjiCallbackPort", CallingConvention = CallingConvention.StdCall)]
        public static extern void RegisterGenjiCallbackPort(int port);

    }
}
