﻿using GenjiDotNetInterop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MatrixAPI = GenjiDotNetInterop.API;


namespace GenjiDotNet
{
    public  class ELTimer
    {
        UInt32 _dwCount;
        int _UserCode;
        short _DngNr;

        public ELTimer() { }

        public ELTimer( int UserCode, short DngNr)
        {
            _dwCount = 0;
            _UserCode = UserCode;
            _DngNr = DngNr;

            short ret = MatrixAPI.Init_MatrixAPI();
            if( ret == -22)
                throw new APIException("ELTimer::ELTimer::Init_MatrixAPI", ret);

            ret = MatrixAPI.Dongle_SetTimer(_UserCode, 0, _DngNr, 85);
            if( ret != 1)
                throw new APIException("ELTimer::ELTimer::Dongle_SetTimer", ret);
        }

        public void Start()
        {
            short ret = MatrixAPI.Dongle_StartTimer(_UserCode, _DngNr, 85);
            if (ret != 1)
                throw new APIException("ELTimer::Start::Dongle_StartTimer", ret);
        }

        public void Stop()
        {
            short ret = MatrixAPI.Dongle_GetTimer(_UserCode, ref _dwCount, 1, 85);
            if (ret != 1)
                throw new APIException("ELTimer::Stop::Dongle_GetTimer", ret);

            ret = MatrixAPI.Dongle_StopTimer(_UserCode, _DngNr, 85);
            if (ret != 1)
                throw new APIException("ELTimer::Stop::Dongle_StopTimer", ret);
        }

        public UInt32 Count()
        {
            return _dwCount; 
        }

        public double Millsec()
        {
            if (_dwCount == 0) return 0;

            return (_dwCount * 64.0) / 24000000.0 * 1000.0;
        }


    }
}
