﻿using System;
using System.Windows.Forms;
using GenjiDotNet;

namespace NetFrameworkSample
{
    public partial class dataForm : Form
    {
        GenjiDotNet.API api;

        public dataForm(GenjiDotNet.API api_)
        {
            InitializeComponent();
            api = api_;
        }

        private void MemSize2_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                MessageBox.Show("領域#2 サイズ: " + api.MemSize2(1) + "バイト");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiを接続してください");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);
            }

            api.Release();

        }

        private void WriteLock_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.LockData2(1234, 1, 987654123, 1);
                MessageBox.Show("ロック成功");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiを接続してください");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);
            }

            api.Release();

        }

        private void WriteUnlock_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                api.LockData2(1234, 0, 987654123, 1);
                MessageBox.Show("アンロック成功");
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiを接続してください");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);

            }

            api.Release();
        }

        private bool WriteData(byte[] data)
        {
            try
            {
                byte[] byteLen = BitConverter.GetBytes(data.Length);

                // データ長　＋　データ
                byte[] byteWrite = new byte[data.Length + byteLen.Length];
                System.Buffer.BlockCopy(byteLen, 0, byteWrite, 0, byteLen.Length);
                System.Buffer.BlockCopy(data, 0, byteWrite, byteLen.Length, data.Length);

                api.Init();
                api.Count();

                api.WriteData2(1234, byteWrite, 0, (short)byteWrite.Length, 1);

                MessageBox.Show("書き込み成功");
            }
            catch (Exception)
            {
                throw;
            }
            finally
            {
                api.Release();
            }
            return true;
        }

        private void btnWrite_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] byteData = System.Text.Encoding.UTF8.GetBytes(textData.Text);
                WriteData(byteData);
                textData.Text = "";
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiを接続してください");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnRead_Click(object sender, EventArgs e)
        {
            try
            {
                api.Init();
                api.Count();

                //データ長読込
                byte[] byteReadLen = new byte[4];
                api.ReadData2(1234, byteReadLen, 0, 4, 1);
                int readDataLen = BitConverter.ToInt32(byteReadLen, 0);

                //データ読込
                byte[] byteReadData = new byte[readDataLen];
                api.ReadData2(1234, byteReadData, 4, (short)readDataLen, 1);

                //テキストボックスにセット
                textData.Text = System.Text.Encoding.UTF8.GetString(byteReadData);
            }
            catch (APIException ex)
            {
                if (ex.Message == "Count" && ex.errorNo == 0)
                    MessageBox.Show("Genjiを接続してください");
                else
                    MessageBox.Show(ex.Message + ";" + ex.errorNo);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            api.Release();
        }
    }
}
