﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace GenjiDotNet
{
    public  class ELTimer
    {
        UInt32 _dwCount;
        int _UserCode;
        short _DngNr;

        GenjiDotNet.API api = new GenjiDotNet.API();

        public ELTimer() { }

        public ELTimer( int UserCode, short DngNr)
        {
            _dwCount = 0;
            _UserCode = UserCode;
            _DngNr = DngNr;


            short ret = api.Init();
            if( ret == -22)
                throw new APIException("ELTimer::ELTimer::Init_MatrixAPI", ret);

            ret = api.SetTimer(_UserCode, 0, _DngNr);
            if( ret != 1)
                throw new APIException("ELTimer::ELTimer::Dongle_SetTimer", ret);
        }

        ~ELTimer()
        {
            api.Release();
        }

        public void Start()
        {
            short ret = api.StartTimer(_UserCode, _DngNr);
            if (ret != 1)
                throw new APIException("ELTimer::Start::Dongle_StartTimer", ret);
        }

        public void Stop()
        {
            short ret = api.GetTimer(_UserCode, ref _dwCount, 1);
            if (ret != 1)
                throw new APIException("ELTimer::Stop::Dongle_GetTimer", ret);

            ret = api.StopTimer(_UserCode, _DngNr);
            if (ret != 1)
                throw new APIException("ELTimer::Stop::Dongle_StopTimer", ret);
        }

        public UInt32 Count()
        {
            return _dwCount; 
        }

        public double Millsec()
        {
            if (_dwCount == 0) return 0;

            return (_dwCount * 64.0) / 24000000.0 * 1000.0;
        }

    }
}
