﻿#include <ostream>
#include "util.h"
#include "test.h"
#include "genji.h"

void detect_devchange(bool removed)
{
    std::cout << (removed==true ? "removed" : "plugged") << std::endl;
}

int main()
{
    //コールバック関数を登録すると、抜き差し時、
    //登録関数が呼び出されます

    RegisterGenjiCallback( detect_devchange );

    if (false == FindGenji()) return -1;

    if (false == LEDTest()) return -1;

    if (false == MemSizeGUSNTest()) return -1;

     // rsa key #1
    if( false == CreateRSAKey(1)) return -1;
    if (false == RSAEncryptTest(1)) return -1;
    if (false == RSASignTest(1)) return -1;

    //rsa key#2
    if( true == RSAKeyImport(2))
    {
        if (false == RSAEncryptTest(2)) return -1;
        if (false == RSASignTest(2)) return -1;
    }
    else
    {
        std::cout << "RSAキーのインポートをスキップ" << std::endl;
        pause();
    }

    if (false == RandTest()) return -1;

    RTCTimeTest();

    cleanup();

    return 0;
}


