
#include "timer.h"
#include "genji.h"

extern int32_t UserCode;
extern int16_t PortNr;
extern int16_t DngNr;


CTimer::CTimer()
{
    init = false;

    if (1 == Dongle_SetTimer(UserCode, 0, 1, 85))
        init = true;

    started = false;
}

CTimer::~CTimer()
{
    if (init == true && started == true)
        Dongle_StopTimer(UserCode, 1, 85);
}

bool CTimer::start()
{
    if (init == true && started == false)
    {
        if (1 == Dongle_StartTimer(UserCode, 1, 85))
            started = true;
    }
   return started;
}

bool CTimer::stop()
{
    if (init == true && started == true)
    {
        if (1 == Dongle_StopTimer(UserCode, 1, 85))
            started = false;
    }

    return !started;
}

double CTimer::interval() const
{
    if (init == true && started == true)
    {
        uint32_t dwCount;
        if (1 == Dongle_GetTimer(UserCode, &dwCount, 1, 85))
            return (dwCount * 64.) / 24000000. * 1000.;
    }

    return -1;
}
