#include <sstream>
#include <unistd.h>
#include <algorithm> 
#include <iostream>

void ltrim(std::string& s) {
    s.erase(s.begin(), std::find_if(s.begin(), s.end(), [](unsigned char ch) {
        return !std::isspace(ch);
        }));
}

void rtrim(std::string& s) {
    s.erase(std::find_if(s.rbegin(), s.rend(), [](unsigned char ch) {
        return !std::isspace(ch);
        }).base(), s.end());
}

void trim(std::string& s) {
    ltrim(s);
    rtrim(s);
}

void pause(unsigned int interval)
{
//    MessageBeep(0);
    usleep(interval*1000);
}

void printHex(const unsigned char* data, int len)
{
    std::stringstream ss;
    for (int i = 0; i < len; i++)
        ss << std::hex << (short)data[i];

    std::cout << ss.str() << std::endl;
}
