//
//  BasicItem.swift
//  GenjiAPITest
//
//

import SwiftUI


struct EditableItem: Identifiable, Hashable {
    var id = UUID()
    var name: String
}

struct BasicAPIView: View {
    @State var count: Int16=0
    @State var serNr: String=""
    @State var gusn: String=""
    @State var fields: [EditableItem] = Array(repeating:EditableItem(name:"0"), count: 128)
    @Binding var currentDngNr: Int16
    

    var body: some View {
        
        if currentDngNr > 0{
            VStack{
                HStack{
                    VStack{
                        
                        HStack{
                            HStack{
                                Text("Serial#")
                                    .font(.title2)
                                    .multilineTextAlignment(.leading)
                                    .frame(width: 70.0, height: 15.0)
                                    .padding(.vertical, 11.0)
                                
                                
                                Text("\(serNr)")
                                    .frame(width: 150.0, height: 15.0)
                            }
                            
                            
                            HStack{
                                Text("GUSN")
                                    .font(.title2)
                                    .multilineTextAlignment(.leading)
                                    .padding(.vertical, 11.0)
                                    .frame(width: 70.0, height: 15.0)
                                
                                Text("\(gusn)")
                                    .frame(width: 150.0, height: 15.0)
                            }
                            
                            Spacer()
                        }
                        .padding(.horizontal, 11.0)
                    }
                }
                
                
                LEDTestView(currentDngNr: $currentDngNr)
                    .padding(.horizontal, 11.0)
                
                HStack{
                    FieldListView(currentDngNr: $currentDngNr,items:$fields,)
                        .padding(.vertical, 11.0)
                        .onChange(of: currentDngNr)
                    {
                        readDongle()
                    }
                    
                    .onAppear{
                        readDongle()
                    }
                    Spacer()
                    
                    XTeaTestView(currentDngNr: $currentDngNr)
                }
                
                Spacer()
            }
        }
        
    }
      
    func readDongle(){
        
        count=Dongle_Count(85)
        serNr=String(Dongle_ReadSerNr(1234,currentDngNr,85))
        
        let ptr = UnsafeMutablePointer<UInt8>.allocate(capacity: 17)
        
        gusn.removeAll()
        if( 1 == Dongle_ReadGUSN(1234,ptr,currentDngNr,85) )
        {
            for i in 0..<16{
                gusn.append(String(UnicodeScalar(Int(exactly: ptr[i])!)!))
            }
        }
        
        ptr.deallocate()
        
        let data = UnsafeMutablePointer<UInt32>.allocate(capacity: 128)
        
        if( 128 == Dongle_ReadData( 1234, data, 128, currentDngNr, 85) )
        {
            for i in 0..<128{
                fields[i].name=String(data[i])
            }
        }

        data.deallocate()
    }

}

#Preview {
    @Previewable @State var dngNr:Int16=1
    BasicAPIView(currentDngNr:$dngNr)
}


