//
//  ContentView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct ContentView: View {

    @EnvironmentObject var observer: NotificationObserver
    
    var body: some View {
        
        VStack {
            if observer.notificationReceived==1 {
                
                Text("Remove Notification was received! ")
                    .font(.headline)
                    .foregroundColor(.red)
                
            }
            else if observer.notificationReceived == 2{
                    Text("Connect Notification was received!")
                        .font(.headline)
                        .foregroundColor(.green)
            } else {
                Text("Waiting for device change notification...")
                    .foregroundColor(.gray)

            }
        }
     
        VStack{
          MenuList()
        }
    }
}


 #Preview {

    ContentView()
         .environmentObject(NotificationObserver()) 
}

