//
//  EncryptView.swift
//  GenjiAPITest
//

import SwiftUI
import UniformTypeIdentifiers

struct EncryptView: View {
    @Binding var currentDngNr: Int16
   
    var body: some View {
        
        if currentDngNr >  0 {
                       
            RSAEncryptView(currentDngNr: $currentDngNr)
                .padding(.top, 10)
            
            HMACShaView(currentDngNr: $currentDngNr)
                .padding(.top, 10)
        }
        
    }
  
}

#Preview {
    @Previewable @State var dngNr:Int16 = 0
    EncryptView(currentDngNr: $dngNr)
}
