//
//  FieldListView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct FieldListView: View {
    @Binding var currentDngNr: Int16
    @Binding var items: [EditableItem]
    @State var showWriteSuccess: Bool = false
    @State var showWriteError: Bool = false
    @State var area1Locked:Bool = false
    @State var showLockSuccess = false
    @State var showLockError = false
    @State var showUnlockSuccess=false
    @State var showUnlockError=false
    
    var body: some View {
        
        GroupBox{
            VStack{
                HStack{
                    Toggle(isOn:$area1Locked) {
                    }
                    
                    Button(area1Locked==true ? "Unlock" : "Lock") {
                        if area1Locked{
                            let ret = Dongle_LockData(1234,0, 987654123, currentDngNr,85)
                            if ret == 1{
                                //showLockSuccess.toggle()
                                area1Locked=false
                            }
                            else{
                                showUnlockError.toggle()
                            }
                        }
                        else{
                            let ret = Dongle_LockData(1234,1, 987654123, currentDngNr,85)
                            if ret == 1 {
                                //showUnlockSuccess.toggle()
                                area1Locked=true
                            }
                            else{
                                showLockError.toggle()
                            }
                        }
                    }
                    .clipShape(Capsule())
                    .padding(.trailing, 20)
                    .onAppear(){
                    
                        let ret = Dongle_LockData(1234,1, 987654123, currentDngNr,85)
                        
                        //lock success, meaning it was not locked
                        if ret == 1{
                            //unlock
                            Dongle_LockData(1234,0,987654123, currentDngNr, 85)
                        }
                        else if ret == -9{
                            area1Locked = true
                        }
                    }
                    .alert("Success", isPresented: $showLockSuccess) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Locked")
                    }
                    .alert("Error", isPresented: $showLockError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Lock Error")
                    }
                    .alert("Success", isPresented: $showUnlockSuccess) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Unlocked")
                    }
                    .alert("Error", isPresented: $showUnlockError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Unlock Error")
                    }
                    
                    Button("Save"){
                        var data:[Int32] = []
                        
                        for i in 0..<128{
                            data.append(Int32(items[i].name) ?? 0)
                        }
                        
                        let ret = Dongle_WriteData(1234,data,128,currentDngNr,85)
                        if ret == 128{
                            showWriteSuccess.toggle()
                        }else{
                            showWriteError.toggle()
                        }
                    }
                    .clipShape(Capsule())
                    .font(.system(size: 16)).bold(true)
                    .foregroundColor(Color.blue)
                    .alert("Success", isPresented: $showWriteSuccess) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Written")
                    }
                    .alert("Error", isPresented: $showWriteError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Write Error")
                    }
                }
                
                List {
                    ForEach(0..<128 ) { index in
                        HStack{
                            // Use a TextField for direct editing within the row
                            Text("Field" + String(index+1))
                                .font(.subheadline)
                                .foregroundColor(Color.blue)
                                .multilineTextAlignment(.center)
                                .frame(width: 50)
                            
                            TextField("Enter Value", text: $items[index].name)
                                .textFieldStyle(PlainTextFieldStyle())
                                .frame(width: 100)
                                .foregroundColor(Color.black)
                                .padding(EdgeInsets(top: 6, leading: 6, bottom: 6, trailing: 6))
                                .cornerRadius(5)
                                .overlay(
                                    RoundedRectangle(cornerRadius: 5)
                                        .stroke(lineWidth: 1.0)
                                )
                                .onChange(of: items[index].name) {
                                    
                                    items[index].name = items[index].name.filter { "0123456789".contains($0) }
                                    if items[index].name.count >= 10 {
                                    
                                        if let _ = UInt32(items[index].name){
                                           
                                        }
                                       else {
                                           items[index].name = String(UInt32.max)
                                        }
                                        items[index].name = String(items[index].name.prefix(10))
                                    }
                                }
                        }
                    }
                }
                .frame(width:220)
                .scrollContentBackground(.hidden)
                .background(Color(NSColor.windowBackgroundColor))
            }
        }
    }

    func unlockGenji(){
        let ret = Dongle_LockData(1234, 0, 987654123, currentDngNr,85)
        if ret != 1{
            
        }
    }
    
    func lockGenji(){
        let ret = Dongle_LockData(1234,1, 987654123, currentDngNr,85)
        if ret != 1{
            
        }
    }
}

/*
 #Preview {
    FieldListView()
}
*/
