//
//  HMACShaView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct HMACShaView: View {
    @Binding var currentDngNr: Int16
    @State private var hmacKey: String = ""
    @State private var dataToHash: String = ""
    @State private var showSuccess: Bool = false
    @State private var showError: Bool = false
    @State private var hashResult: String = ""
    @State private var showKeyEmpty: Bool = false
    @State private var showDataEmpty: Bool = false

    var body: some View {
        
        GroupBox("HMACSHA"){
            TextField("HMAC key", text:$hmacKey)
                .padding(.horizontal,50)
            
            Button("Write"){
                
                if hmacKey.count == 0 {
                    showKeyEmpty.toggle()
                    return
                }
                
               if( 1 == Dongle_WriteKeyHMACSHA1( 1234, Array(hmacKey.utf8), currentDngNr, 1) )
               {
                   showSuccess.toggle( )
               }
               else{
                   showError.toggle( )
                }
            }
            .clipShape(Capsule())
            .alert("Success", isPresented: $showSuccess) {
                // ダイアログ内で行うアクション処理...
                
            } message: {
                Text("HMAC key saved")
            }
            .alert("Error", isPresented: $showError) {
                // ダイアログ内で行うアクション処理...
                
            } message: {
                Text("HMAC key save error")
            }
            .alert("Warning", isPresented: $showKeyEmpty) {
                // ダイアログ内で行うアクション処理...
                
            } message: {
                Text("HMAC key empty")
            }
            
            TextField("Data to hash", text:$dataToHash, axis: .vertical)
                .padding(.horizontal,50)
                .lineLimit(3...5)
            
            Button("Hash"){
   
                if dataToHash.count == 0
                {
                   showDataEmpty.toggle()
                    return
                }
                
                let ptrHash = UnsafeMutablePointer<UInt8>.allocate(capacity: 32)
                let ptrHashLen = UnsafeMutablePointer<Int16>.allocate(capacity: 1)
                ptrHashLen[0] = 32
                
                if( 1 == Dongle_HMACSHA1(1234,Array(dataToHash.utf8),Int16(dataToHash.utf8.count),ptrHash,ptrHashLen,currentDngNr,85) )
                {
                    hashResult=""
                    
                    let len = Int16(ptrHashLen.pointee)
                    debugPrint("hash len=\(len) bytes")
                    for i in 0..<len{
                        hashResult.append(String(format:"%02x", ptrHash[Int(i)]))
                    }
                    debugPrint(hashResult)
                    
                }
                
                ptrHash.deallocate()
                ptrHashLen.deallocate()
                
            }
            .clipShape(Capsule())
            .alert("Warning", isPresented: $showDataEmpty) {
                // ダイアログ内で行うアクション処理...
                
            } message: {
                Text("Data to hash is empty")
            }
            
            Text(hashResult)
                .bold()
        }
    }
}

#Preview {
    @Previewable @State var dngNr:Int16 = 0
    HMACShaView(currentDngNr: $dngNr)
}
