//
//  LEDTestView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct LEDTestView: View {
    @Binding var currentDngNr: Int16
    var body: some View {
        GroupBox(label: Text("LED Test").font(.headline)) {
            HStack{
                if(currentDngNr > 0){
                    Spacer()
                    Button(" ON ") {
                        Dongle_SetLED(-1, currentDngNr, 85)
                    }
                    .clipShape(Capsule())
                    .frame(maxWidth: .infinity, minHeight: 48)
                    .font(.system(size: 16))

                    
                    Button(" OFF ") {
                        Dongle_SetLED(0, currentDngNr, 85)
                    }
                    .clipShape(Capsule())
                    .frame(maxWidth: .infinity, minHeight: 48)
                    .font(.system(size: 16))
                    
                    Button(" Blink ") {
                        Dongle_SetLED(3, currentDngNr, 85)
                    }
                    .clipShape(Capsule())
                    .frame(maxWidth: .infinity, minHeight: 48)
                    .font(.system(size: 16))
                    
                }
            }
        }
       


    }
}

#Preview {
    @Previewable @State var currentDngNr: Int16 = 1
    LEDTestView(currentDngNr: $currentDngNr)
}
