//
//  TestList.swift
//  GenjiAPITest
//
//

import SwiftUI

struct MenuItem: Identifiable {
    let id = UUID()
    let menuName: String
}
struct MenuList: View {
    
    @State var currentDngNr: Int16 = 0
    
    var body: some View {
        let items : [MenuItem] = [MenuItem(menuName: "Basic API"),MenuItem(menuName: "Data#2"),MenuItem(menuName: "KeyPair"),MenuItem(menuName: "Encrypt"),MenuItem(menuName: "Sign")]
        
        @State var selectedMenu: String? = nil
        
        NavigationSplitView{
            
            List(items, selection: $selectedMenu) { item in
                
                if item.menuName == "Basic API" {
                    NavigationLink{
                        
                        BasicAPIView(currentDngNr: $currentDngNr)
                        
                    } label:{
                        Text(item.menuName)
                            .multilineTextAlignment(.center)
                            .font(.title.bold())
                    }.tag(item.menuName)
                }
                else if item.menuName == "Data#2" {
                    NavigationLink{
                        
                        Data2View(currentDngNr: $currentDngNr)
                        
                    } label:{
                        Text(item.menuName)
                            .multilineTextAlignment(.center)
                            .font(.title.bold())
                    }.tag(item.menuName)
                }
                else if item.menuName == "KeyPair" {
                    NavigationLink{
                        
                        KeyView(currentDngNr: $currentDngNr)
                        
                    } label:{
                        Text(item.menuName)
                            .multilineTextAlignment(.center)
                            .font(.title.bold())
                    }.tag(item.menuName)
                }
                else if item.menuName == "Encrypt" {
                    NavigationLink{
                        
                        EncryptView(currentDngNr: $currentDngNr)
                        
                    } label:{
                        Text(item.menuName)
                            .multilineTextAlignment(.center)
                            .font(.title.bold())
                    }.tag(item.menuName)
                }
                else {
                    NavigationLink{
                        
                        SignView(currentDngNr:$currentDngNr)
                        
                    } label:{
                        Text(item.menuName)
                            .multilineTextAlignment(.center)
                            .font(.title.bold())
                    }
                }
                
            }
            .background(Color(NSColor.windowBackgroundColor))
            .navigationTitle("TestMenu")
        
           
            
            DongleListView(currentDngNr:$currentDngNr)
            .background(Color.white)
            
        }detail:
        {
            //Text("Select a test menuitem")
            BasicAPIView(currentDngNr:$currentDngNr)
        }

 
        

    }
}

#Preview {
    MenuList()
}
