//
//  RSAKeyView.swift
//  GenjiAPITest
//
//

import SwiftUI
import UniformTypeIdentifiers

struct RSAKeyView: View {
    @Binding var currentDngNr: Int16
    @State private var droppedPubKey: Data?
    @State private var droppedPrivKey: Data? = nil
    @State private var isTargeted: Bool = false
    @State private var showCreateError:Bool = false
    @State private var showCreateSuccess:Bool = false
    @State private var showImportError:Bool = false
    @State private var showImportSuccess:Bool = false
    @State private var showPrivKeyDropError:Bool = false
    @State private var showPubKeyDropError:Bool = false

    var body: some View {
        
        VStack{
            GroupBox("Saving a keypair at Index #1"){
                
                Button("Create RSA Keypair"){
                    
                    if 1 == Dongle_CreateRSAKeyPair(1234,1,currentDngNr,85) {
                        showCreateSuccess.toggle()
                    }
                    else{
                        showCreateError.toggle()
                    }
                    
                }
                .padding(5)
                .clipShape(Capsule())
                .alert("Success", isPresented: $showCreateSuccess) {
                    // ダイアログ内で行うアクション処理...
                    
                } message: {
                    Text("Keypair created and saved at #1")
                }
                .alert("Error", isPresented: $showCreateError) {
                    // ダイアログ内で行うアクション処理...
                    
                } message: {
                    Text("Keypair Create Error")
                }
                
            }
            
            GroupBox("Saving a keypair at Index #2"){
                HStack{
                    VStack{
                        if let droppedPrivKey {
                            
                            Button(action: {
                                self.droppedPrivKey = nil
                            }){
                                HStack {
                                    Text("Private Key")
                                        .foregroundColor(.green)
                                        .bold(isTargeted)
                                    
                                    Image(systemName: "eraser")
                                }
                                
                            }
                            
                            
                        }else{
                            Text("Drop private key file")
                                .padding(5)
                                .background(Color.blue)
                                .foregroundColor(.white)
                        }
                    }
                    .clipShape(Capsule())
                    .padding(.leading, 10.0)
                    // データ型として Data.self を指定
                    .dropDestination(for: Data.self) { items, location in
                        // items はドロップされた Data オブジェクトの配列
                        if let data = items.first {
                            
                            if data.count == 330{
                                self.droppedPrivKey = data
                                debugPrint("privkey dropped")
                                return true
                            }
                        }
                        showPrivKeyDropError.toggle()
                        return false
                        
                    } isTargeted: { targeted in
                        // isTargeted の状態を更新し、視覚的なフィードバックを提供
                        self.isTargeted = targeted
                    }
                    .alert("Error", isPresented: $showPrivKeyDropError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Not a Genji private key file")
                    }
                    
                    
                    
                    VStack{
                        if let droppedPubKey {
                            
                            Button(action: {
                                self.droppedPubKey = nil
                            }){
                                HStack {
                                    Text("Public Key")
                                        .foregroundColor(.green)
                                        .bold(isTargeted)
                                    
                                    Image(systemName: "eraser")
                                }
                                
                            }
                            
                            
                        }else{
                            Text("Drop public key file")
                                .padding(5)
                                .background(Color.blue)
                                .foregroundColor(.white)
                        }
                    }
                    .clipShape(Capsule())
                    .padding(.leading, 10.0)
                    // データ型として Data.self を指定
                    .dropDestination(for: Data.self) { items, location in
                        // items はドロップされた Data オブジェクトの配列
                        if let data = items.first {
                            
                            if data.count == 136{
                                self.droppedPubKey = data
                                debugPrint("pubkey dropped")
                                return true
                            }
                        }
                        showPubKeyDropError.toggle()
                        return false
                        
                    } isTargeted: { targeted in
                        // isTargeted の状態を更新し、視覚的なフィードバックを提供
                        self.isTargeted = targeted
                    }
                    .alert("Error", isPresented: $showPubKeyDropError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Not a Genji public key file")
                    }
                }
                
                if let pubkey=droppedPubKey, let privkey=droppedPrivKey{
                    Button("Import keys")
                    {
                        if 1 == Dongle_WriteRSAKey(1234, 2, 1, UInt16(privkey.count),
                                                   privkey.withUnsafeBytes { Array($0) },currentDngNr,85)
                        {
                            if 1 == Dongle_WriteRSAKey(1234, 2, 0, UInt16(pubkey.count),
                                                       pubkey.withUnsafeBytes { Array($0) },currentDngNr,85)
                            {
                                showImportSuccess.toggle()
                                return
                            }
                        }
                        showImportError.toggle()
                    }
                    .alert("Success", isPresented: $showImportSuccess) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Imported the private and public key at #2")
                    }.alert("Error", isPresented: $showImportError) {
                        // ダイアログ内で行うアクション処理...
                        
                    } message: {
                        Text("Failed to import keys")
                    }
                }
            }
            .padding(.top,20)
        }
        .padding(.top, 10)
    }
}


#Preview {
    @Previewable @State var dngNr:Int16 = 0
    RSAKeyView(currentDngNr: $dngNr)
}
