//
//  SignView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct SignView: View {
    @Binding var currentDngNr:Int16
    @State var currentKeyIndex:Bool = true
    @State var dataToSign:String = ""
    @State var signature:String = ""
    @State var showDataEmpty:Bool = false
    @State var showVerified:Bool = false
    @State var showNotVerified:Bool = false
    
    var body: some View {

        if currentDngNr > 0 {
            
            
            Toggle(isOn:$currentKeyIndex) {
                if currentKeyIndex{
                    Text("Current key: Key#1")
                }
                else{
                    Text("Current key: Key#2")
                }
            }
            
            GroupBox("Sign/Verify"){
                
                TextField("Data to sign", text:$dataToSign, axis: .vertical)
                    .padding(.horizontal,50)
                    .lineLimit(5...10)
                
                Button("Sign"){
                    
                    if dataToSign.count == 0
                    {
                        showDataEmpty.toggle()
                        return
                    }
                    
                    let ptrSig = UnsafeMutablePointer<UInt8>.allocate(capacity: 129)
                    let ptrSigLen = UnsafeMutablePointer<Int16>.allocate(capacity: 1)
                    ptrSigLen[0] = 129
                    
                    if 1 == Dongle_SignDataRSA(1234, currentKeyIndex==true ? 1 : 2, Array(dataToSign.utf8),Int16(dataToSign.utf8.count), ptrSig, ptrSigLen, currentDngNr,85){
                        
                        signature=""
                        
                        let len = Int16(ptrSigLen.pointee)
                        
                        debugPrint("len=\(len)")
                        
                        for i in 0..<len{
                            signature.append(String(format:"%02x", ptrSig[Int(i)]))
                        }
                    }
                    
                }
                .clipShape(Capsule())
                .alert("Warning", isPresented: $showDataEmpty) {
                    // ダイアログ内で行うアクション処理...
                    
                } message: {
                    Text("Data to sign is empty")
                }
                
                TextField("Signature", text:$signature,axis: .vertical)
                    .padding(.horizontal,50)
                    .lineLimit(5...7)
                
                
                Button("Verify"){
                    
                    let sigBinary = RSAEncryptView.hextoUint8Array(hexString: signature)
                    
                    if 1 == Dongle_VerifySigRSA(1234,currentKeyIndex==true ? 1:2,Array(dataToSign.utf8),Int16(dataToSign.utf8.count),
                                                sigBinary, Int16(sigBinary.count), currentDngNr, 85)
                    {
                        showVerified.toggle()
                    }
                    else{
                        showNotVerified.toggle()
                    }
                    
                }
                .clipShape(Capsule())
                .alert("Verified", isPresented: $showVerified) {
                    // ダイアログ内で行うアクション処理...
                    
                } message: {
                    Text("Data/Signature successfully verified")
                }
                .alert("Error", isPresented: $showNotVerified) {
                    // ダイアログ内で行うアクション処理...
                    
                } message: {
                    Text("Signature not valid")
                }
            }
        }
        
    }
}

#Preview {
    @Previewable @State var dngNr:Int16 = 0
    SignView(currentDngNr: $dngNr)
}
