//
//  XTeaTestView.swift
//  GenjiAPITest
//
//

import SwiftUI

struct XTeaTestView: View {
    @Binding var currentDngNr:Int16
    @State var key:[String] = ["0","0","0","0"]
    @State var plaindata:[String] = ["0","0"]
    @State var encdata:[String] = ["0","0"]
    @State var decdata:[String] = ["0","0"]
    @State var isShowSuccess = false
    @State var isShowError = false

    var body: some View {
        
        Spacer()
        
        GroupBox(label: Text("XTEA Test").font(.headline))
        {
            VStack{
                
                    HStack{
                        Spacer()
                        
                        Text("Key1:")
                        TextField("key1",text:$key[0])
                            .frame(width:120)
                            .onChange(of: key[0]) {
                                
                                key[0] = key[0].filter { "0123456789".contains($0) }
                                
                                if key[0].count >= 10 {
                                    key[0] = String(UInt32.max)
                                    key[0] = String(key[0].prefix(10))
                                }
                            }
                        
                        Spacer()
                        
                        Text("Key2:")
                        TextField("key2",text:$key[1])
                            .frame(width:120)
                            .onChange(of: key[1]) {
                                
                                key[1] = key[1].filter { "0123456789".contains($0) }
                                
                                if key[1].count >= 10 {
                                    key[1] = String(UInt32.max)
                                    key[1] = String(key[1].prefix(10))
                                }
                            }
                        
                        Spacer()
                    }
                    .padding(.top,20)
                    
                    
                    HStack{
                        Spacer()
                        
                        Text("Key3:")
                        TextField("key3",text:$key[2])
                            .frame(width:120)
                            .onChange(of: key[2]) {
                                
                                key[2] = key[2].filter { "0123456789".contains($0) }
                                
                                if key[2].count >= 10 {
                                    key[2] = String(UInt32.max)
                                    key[2] = String(key[2].prefix(10))
                                }
                            }
                        Spacer()
                        
                        Text("Key4:")
                        
                        TextField("key4",text:$key[3])
                            .frame(width:120)
                            .onChange(of: key[3]) {
                                
                                key[3] = key[3].filter { "0123456789".contains($0) }
                                
                                if key[3].count >= 10 {
                                    key[3] = String(UInt32.max)
                                    key[3] = String(key[3].prefix(10))
                                }
                            }
                        
                        Spacer()
                    }
                    
                    Button("Write keys"){
                        
                        let nkey = UnsafeMutablePointer<UInt32>.allocate(capacity: 4)
                        
                        nkey[0] = UInt32(key[0]) ?? 0
                        nkey[1] = UInt32(key[1]) ?? 0
                        nkey[2] = UInt32(key[2]) ?? 0
                        nkey[3] = UInt32(key[3]) ?? 0
                        
                        if( Dongle_WriteKey(1234,nkey,currentDngNr,85) > 0 )
                        {
                            isShowSuccess.toggle()
                            key[0] = ""
                            key[1] = ""
                            key[2] = ""
                            key[3] = "" 
                        }
                        else{
                            isShowError.toggle()
                        }
                        
                        nkey.deallocate()
                    }
                    .font(.headline)
                    .alert("Success", isPresented: $isShowSuccess) {
                                // ダイアログ内で行うアクション処理...

                            } message: {
                                Text("Written")
                            }
                    .alert("Error", isPresented: $isShowError) {
                            // ダイアログ内で行うアクション処理...

                        } message: {
                            Text("Write Error")
                        }

                
                
                
                Group {
                    
                    VStack {
                        HStack{
                            Spacer()
                            
                            Text("Plain Data1:")
                            TextField("Data1",text:$plaindata[0])
                                .frame(width:120)
                                .onChange(of: plaindata[0]) {

                                    plaindata[0] = plaindata[0].filter { "0123456789".contains($0) }

                                    if plaindata[0].count >= 10 {
                                        plaindata[0] = String(UInt32.max)
                                        plaindata[0] = String(plaindata[0].prefix(10))
                                    }
                                }
 
                            Spacer()
                            
                            Text("Plain Data2:")
                            
                            TextField("Data2",text:$plaindata[1])
                                .frame(width:120)
                                .onChange(of: plaindata[1]) {
                                    
                                    plaindata[1] = plaindata[1].filter { "0123456789".contains($0) }

                                    if plaindata[1].count >= 10 {
                                        plaindata[1] = String(UInt32.max)
                                        plaindata[1] = String(plaindata[1].prefix(10))
                                    }
                                }
                            Spacer()
                        }
                        .padding(.top,20)
                        
                        
                        Button("Encrypt"){
                            let plain = UnsafeMutablePointer<UInt32>.allocate(capacity: 2)
                            
                            plain[0] = UInt32(plaindata[0]) ?? 0
                            plain[1] = UInt32(plaindata[1]) ?? 0
                            
                            Dongle_EncryptData(1234, plain, currentDngNr,85)
                        
                            encdata[0] = String(plain[0])
                            encdata[1] = String(plain[1])
                            
                            plain.deallocate()
                        }
                        
                        .font(.headline)
                        .padding(.horizontal,20)
                        
                        HStack{
                            Spacer()
                            
                            Text("Encrypted1:")
                            TextField("Encrypted1", text:$encdata[0])
                                .frame(width:120)
                               
                            
                            Spacer()
                            
                            Text("Encrypted2:")
                            TextField("Encrypted2", text:$encdata[1])
                                .frame(width:120)

                            
                            Spacer()
                        }
                        
                        Button("Decrypt"){
                            let enc = UnsafeMutablePointer<UInt32>.allocate(capacity: 2)
                            
                            enc[0] = UInt32(encdata[0]) ?? 0
                            enc[1] = UInt32(encdata[1]) ?? 0
                            
                            Dongle_DecryptData(1234, enc, currentDngNr,85)
                        
                            decdata[0] = String(enc[0])
                            decdata[1] = String(enc[1])
                            
                            enc.deallocate()
   
                        }
                        .font(.headline)
                        .padding(.horizontal,20)
                        
                        HStack{
                            Spacer()
                            
                            Text("Decrypted1:")
                            TextField("Decrypted1", text:$decdata[0])
                                .frame(width:120)

                            
                            Spacer()
                            
                            Text("Decrypted2:")
                            TextField("Decrypted2", text:$decdata[1])
                                .frame(width:120)

                            
                            Spacer()
                        }
                    }
                }
                
                
            }
        }
        Spacer()
        
    }
}

#Preview {
    @Previewable @State var currentDngNr:Int16=1
    XTeaTestView(currentDngNr:$currentDngNr)
}
