package main

import (
	"fmt"
	"example.com/genji"
)


//
// Timer class
//
type GenjiTimer struct {
	UserCode int32
	bInit bool
	dNr int16
}
func (t *GenjiTimer) init(_UserCode int32, _dNr int16) {
	t.bInit = false
	t.dNr = _dNr
	t.UserCode = _UserCode
}
func (t *GenjiTimer) start()  {
	
	t.bInit=false

	ret := genji.Dongle_SetTimer(t.UserCode,0,t.dNr)
	if 1 == ret{
		ret = genji.Dongle_StartTimer(t.UserCode,t.dNr)
		if ret == 1{
			t.bInit=true
			return
		}else{
			fmt.Println("StarTimer error", ret)
		}
	}else{
		fmt.Println("SetTimer error", ret)
	}
}
func (t *GenjiTimer) stop() (interval int) {
	if( t.bInit == false){
		interval = -1
		return
	}

	var timerCount uint32
	if 1 == genji.Dongle_GetTimer(t.UserCode, &timerCount, t.dNr){
        interval = (int)(((float64)(timerCount) * 64.) / 24000000. * 1000.)
	}else{
		fmt.Println("Gettimer error")
		interval = -1;
	}

	if 1 == genji.Dongle_StopTimer(t.UserCode,t.dNr){
		t.bInit=false
		return 
	}

	return
}
func newGenjiTimer( UserCode int32, _dNr int16) *GenjiTimer{
	t := new(GenjiTimer)
	t.init(UserCode,_dNr)
	return t
}
