#pragma once

#include <stdint.h>
#include <time.h>

#if defined(__APPLE__) || defined(__unix__)
	#ifndef __WATCOMC__
		#define WINAPI
	#endif
#else
   #if !defined(WINAPI)
      #define WINAPI __stdcall
   #endif
#endif

#if !defined(BOOL)
  #define BOOL int
#endif

#if !defined(LOWORD)
    #define LOWORD(l)           ((int16_t)(((int32_t)(l)) & 0xffff))
#endif

#if !defined(HIWORD)
    #define HIWORD(l)           ((int16_t)((((int32_t)(l)) >> 16) & 0xffff))
#endif

#ifdef __cplusplus
extern "C" {
#endif


int16_t  WINAPI Init_MatrixAPI(void);
int16_t  WINAPI Release_MatrixAPI(void);
int32_t  WINAPI GetVersionAPI(void);
int32_t  WINAPI GetVersionDRV(void);
int32_t  WINAPI GetVersionDRV_USB(void);
int16_t  WINAPI GetPortAdr(int16_t);
int16_t  WINAPI Dongle_WriteData(int32_t,  const int32_t*, int16_t, int16_t, int16_t);
int16_t  WINAPI Dongle_WriteDataEx(int32_t, const int32_t*, int16_t, int16_t, int16_t, int16_t);
int16_t  WINAPI Dongle_ReadData(int32_t, int32_t*, int16_t, int16_t, int16_t);
int16_t  WINAPI Dongle_ReadDataEx(int32_t, int32_t*, int16_t, int16_t, int16_t, int16_t);
int32_t  WINAPI Dongle_ReadSerNr(int32_t, int16_t, int16_t);
int16_t  WINAPI Dongle_Find(void);
int32_t  WINAPI Dongle_Version(int16_t, int16_t);
int32_t  WINAPI Dongle_Model(int16_t, int16_t);
int16_t  WINAPI Dongle_MemSize(int16_t, int16_t);
int16_t  WINAPI Dongle_Count(int16_t);

int16_t  WINAPI Dongle_WriteKey(int32_t UserCode,
	int32_t* KeyData,
	int16_t DongleNr,
	int16_t PortNr);

int16_t  WINAPI Dongle_GetKeyFlag(int32_t UserCode, int16_t DongleNr, int16_t PortNr);

int16_t  WINAPI Dongle_EncryptData(int32_t UserCode, int32_t* DataBlock, int16_t DongleNr, int16_t PortNr);
int16_t  WINAPI Dongle_DecryptData(int32_t UserCode, int32_t* DataBlock, int16_t DongleNr, int16_t PortNr);

int16_t  WINAPI SetConfig_MatrixNet(int16_t, const char*);
int16_t  WINAPI LogIn_MatrixNet(int32_t, int16_t, int16_t);
int16_t  WINAPI LogOut_MatrixNet(int32_t, int16_t, int16_t);
int32_t  WINAPI GetConfig_MatrixNet(int16_t Category);



int16_t WINAPI Dongle_SetLED( int16_t mode, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_GetTime(int32_t UserCode, struct tm* pCurTime, int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_GetRand( int32_t UserCode, int16_t siz, unsigned char* pRand, int16_t dNr, int16_t PortNr );

int16_t WINAPI Dongle_CreateRSAKeyPair( int32_t UserCode, int16_t idx, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_WriteRSAKey(int32_t UserCode, int16_t idx, BOOL bPrivKey, uint16_t keySize, const unsigned char* pKeyBuf, int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_LockRSAKeyPair( int32_t UserCode, int16_t idx, BOOL bLock, uint32_t lockKey, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_GetRSAPubKey( int32_t UserCode, int16_t idx, unsigned char* pubKey, short* pubKeyLen,int16_t dNr, int16_t PortNr );
int16_t WINAPI EncryptByCOSRsaPubKey(const unsigned char* pubKey, short pubKey_len, const unsigned char* plainText, short plainTextLen,	unsigned char* cipher, short* cipherLen);

int16_t WINAPI Dongle_EncryptDataRSA( int32_t UserCode,int16_t idx,const unsigned char* plainText, short plainTextLen,unsigned char* cipher,short* cipherLen,int16_t dNr,int16_t PortNr );
int16_t WINAPI Dongle_DecryptDataRSA( int32_t UserCode,int16_t idx,const unsigned char* cipher,short cipherLen, unsigned char* plainText,short* plainTextLen,int16_t dNr,int16_t PortNr );

int16_t WINAPI Dongle_SignDataRSA(int32_t UserCode, int16_t idx,const unsigned char* msg, short msgLen, unsigned char* sigData, short* sigLen,int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_VerifySigRSA(int32_t UserCode, int16_t idx,const unsigned char* msg, short msgLen, const unsigned char* sigData, short sigLen,int16_t dNr, int16_t PortNr);

int16_t WINAPI Dongle_DecryptDataTDES( int32_t UserCode, const unsigned char* iv, const unsigned char*cipher, int16_t cipherLen, unsigned char*plain, int16_t* plainLen, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_EncryptDataTDES( int32_t UserCode, const unsigned char* iv, const unsigned char*plainText, int16_t plainLen, unsigned char*cipher, int16_t* cipherLen, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_WriteKeyTDES(int32_t UserCode, const unsigned char* key, int16_t dNr, int16_t PortNr );

int16_t WINAPI Dongle_WriteKeyHMACSHA1(int32_t UserCode, const unsigned char* key, int16_t dNr, int16_t PortNr );
int16_t WINAPI Dongle_HMACSHA1(int32_t UserCode, const unsigned char*plainText, int16_t plainLen, unsigned char*hash, int16_t* hashLen, int16_t dNr, int16_t PortNr );

int16_t WINAPI Dongle_MemSize2(int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_WriteData2(int32_t UserCode, const unsigned char* data, uint16_t pos, uint16_t len, int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_ReadData2(int32_t UserCode, unsigned char* data, uint16_t pos, uint16_t len, int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_LockData2(int32_t UserCode, BOOL bLock, uint32_t lockKey, int16_t dNr, int16_t PortNr);

int16_t WINAPI Dongle_LockData(int32_t UserCode, BOOL bLock, uint32_t lockKey, int16_t dNr, int16_t PortNr);

int16_t WINAPI Dongle_SetTimer(int32_t UserCode, int16_t mode,  int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_StartTimer(int32_t UserCode, int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_GetTimer(int32_t UserCode, uint32_t* dwCount,  int16_t dNr, int16_t PortNr);
int16_t WINAPI Dongle_StopTimer(int32_t UserCode, int16_t dNr, int16_t PortNr);

int16_t WINAPI Dongle_ReadGUSN(int32_t UserCode, unsigned char* gSN, int16_t dNr, int16_t PortNr);

//void WINAPI  RegisterGenjiCallback(void (*callback)(bool));
void WINAPI  RegisterGenjiCallbackPort( int port  );

#ifdef __cplusplus
}
#endif



