use crate::genji;

pub struct GenjiTimer<'a>{
    pub mode: i16,
    pub api: &'a genji::Api,
    pub started: bool,
    pub counter: u32,
}


impl GenjiTimer<'_>{

    pub fn start(&mut self, dng_nr:i16)->bool{

        if 1 == self.api.set_timer(self.mode,dng_nr){
            if 1 == self.api.start_timer(dng_nr){
                self.started=true;
                return true;
            }
        }
        false
    }

    pub fn stop(&mut self, dng_nr:i16)->bool {

        if self.started==true {
            let mut cnt = 0;
            
            if 1 == self.api.get_timer(&mut cnt,dng_nr) {
                self.counter = ((cnt as f64 * 64.)  / 24000000. * 1000.) as u32;

            }
            else{
                self.counter = 0;
            }

            if 1 == self.api.stop_timer(dng_nr){
                self.started=false;
                return true;
            }
        }
        false
    }
}